function [uw] = PorePressure(NODE,ELEM,HYDH,EMAT,MatProp,gammaw)

Nn = size(NODE,1);
H = zeros(Nn,1);

if isempty(HYDH)
    uw = zeros(size(NODE,1),1);
else
    K = zeros(Nn,Nn);
    F = zeros(Nn,1);

    IsNodeh = false(Nn,1); 
    h = any(HYDH(:,2)~=0 & ~isnan(HYDH(:,2)) ,2);
    IsNodeh(HYDH(h,1)) = true;

    Nl = sum(sum(HYDH(:,2)~=0 & ~isnan(HYDH(:,2))));
    H0 = sparse([],[],[],size(NODE,1),1,Nl);
    H0(HYDH(:,1),:) = H0(HYDH(:,1),:) + HYDH(:,2);

    for e=1:size(ELEM,2)
        dof = ELEM{e};
        xeset = NODE(dof,:);
        h0 = H0(dof,:);
        k = 3;
        kappa = MatProp(EMAT(e),4)*eye(2);
        if size(dof,2)==3
            [ke,fe] = T3kefe(xeset, kappa, h0, k);
        elseif size(dof,2)==4
            [ke,fe] = Q4kefe(xeset, kappa, h0, k);
        end 
            
        K(dof,dof) = K(dof,dof) + ke;
        F(dof,1) = F(dof,1) + fe;
    end 
    a = 1:size(NODE,1);
    fdof = a(:,~IsNodeh);
    H(fdof,:) = K(fdof,fdof)\F(fdof,:);
    H = H + H0;
    uw = gammaw*(H-NODE(:,2));
end

return 